@extends('layouts.app')

@section('title', 'My Prescriptions')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
        <h1 class="text-3xl font-bold text-gray-800">My Prescriptions</h1>
        <a href="{{ route('doctor.dashboard') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
            <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Prescription #</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Diagnosis</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach($prescriptions as $prescription)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $prescription->prescription_number }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $prescription->patient->full_name }}</td>
                    <td class="px-6 py-4 whitespace-nowrap">{{ $prescription->created_at->format('M d, Y') }}</td>
                    <td class="px-6 py-4">{{ $prescription->diagnosis ?? 'N/A' }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <a href="{{ route('prescriptions.show', $prescription->id) }}" class="text-blue-600 hover:text-blue-900 mr-4">View</a>
                        <a href="{{ route('prescriptions.download', $prescription->id) }}" class="text-green-600 hover:text-green-900">Download PDF</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection

